using System;
using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;

namespace gov.va.med.vbecs.DAL.VistALink.Client
{
	/// <summary>
	/// This exception is thrown when some problems are preventing 
	/// ExecuteRpc method functioning.
	/// Added in scope of CR2761
	/// </summary>
	public class VistALinkClientRPCException : VistALinkException
	{
		/// <summary>
		/// Default constructor. Error message is self-contained and cannot be changed.
		/// </summary>
		public VistALinkClientRPCException()
			: base() {}

		/// <summary>
		/// This constructor allows specifying an error message upon throwing an exception.
		/// </summary>
		/// <param name="message">Human-readable message describing the error.</param>
		public VistALinkClientRPCException( string message ) 
			: base( message ) {}

		/// <summary>
		/// This constructor allows adding inner exception that caused this exception.
		/// </summary>
		/// <param name="message">Human-readable message describing the error.</param>
		/// <param name="innerException">Inner exception that caused this exception.</param>
		public VistALinkClientRPCException( string message, Exception innerException )
			: base( message, innerException ) {}
	}
}
